% Road
% Definuje parametry cesty
%-------------------------------------------------------------------------
% Witten By Tomas Mauder, VUT v Brne, 2014.
%-------------------------------------------------------------------------
road = struct;


%-------------------------------------------------------------------------
%   trida cesty              phi0 * 10^-6
%   A (velmi dobra)          1   
%   B (dobra)                4
%   C (prumerna)             16   
%   D (spatna)               64  
%   E (velmi spatna)         256

road.type = 10;
road.type = road.type * 10^-6;
%-------------------------------------------------------------------------
% interval vlnoveho cisla pro PSD
road.omega0 = 1; % referencni vlna
road.omega1 = 0.063; % nejkratsi vlna
road.omega2 = 62; % nejdelsi vlna
road.omega_cut = 0.0001; % nastavi pozici minimalniho mista kde bude PSD orezano
%-------------------------------------------------------------------------
% Koeficient zvlneni (waviness);
% Dlouhe vlny
road.wL = 2;
% Kratke vlny
road.wS = 2;
%-------------------------------------------------------------------------
% Delka cesty (m)
% zacatek
road.L1 = 0; 
% konec
road.L2 = 100; 
% Pocet vzorku na 1 m cesty
road.N = 4;
% Rozdeleni cesty na L * N intervalu
road.s = [road.L1:1/road.N:(road.L2-1/road.N) road.L2];
%-------------------------------------------------------------------------
% pocet vln pro PSD
%  road.M = 2000;
road.M = size(road.omega1: 1/(road.L2 - road.L1): road.omega2,2);


